#!/bin/bash
export datasets="Cora CiteSeer PubMed cs physics wikics OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_test="0.1 0.5 0.999"
export lambda_list="1e-5 1e-4 1e-3 1e-2 1e-1 1e+0 1e+1"
export k_list="2"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=0

# uniform
for missing_rate in $missing_rates_test
do
for k in $k_list
do
python main.py --dataset Cora --missing_type uniform --lamb 1e-2 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset CiteSeer --missing_type uniform --lamb 1e-3 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset PubMed --missing_type uniform --lamb 1e-3 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset cs --missing_type uniform --lamb 1e+1 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset physics --missing_type uniform --lamb 1e-3 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset wikics --missing_type uniform --lamb 1e+1 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset OGBN-Arxiv --missing_type uniform --lamb 1e-4 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
done
done


# row
for missing_rate in $missing_rates_test
do
for k in $k_list
do
python main.py --dataset Cora --missing_type row --lamb 1e-3 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset CiteSeer --missing_type row --lamb 1e-1 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset PubMed --missing_type row --lamb 1e-2 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset cs --missing_type row --lamb 1e+0 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset physics --missing_type row --lamb 1e-4 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset wikics --missing_type row --lamb 1e-1 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset OGBN-Arxiv --missing_type row --lamb 1e-3 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
done
done

# uniform
for missing_rate in $missing_rates_test
do
for k in 50
do
python main.py --dataset Cora --missing_type uniform --lamb 1e-2 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset CiteSeer --missing_type uniform --lamb 1e-3 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset PubMed --missing_type uniform --lamb 1e-3 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset cs --missing_type uniform --lamb 1e+1 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset physics --missing_type uniform --lamb 1e-3 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset wikics --missing_type uniform --lamb 1e+1 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
python main.py --dataset OGBN-Arxiv --missing_type uniform --lamb 1e-4 --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --k ${k}
done
done